<?php
include 'db.php'; // Include your database connection file

header("Content-Type: application/json");

// Retrieve the testimonial_id from the query parameter
$testimonial_id = $_GET['testimonial_id'] ?? null;

// Build the base query
$query = "SELECT * FROM testimonial WHERE Delete_status = 0";

// Add filter if testimonial_id is provided
if ($testimonial_id) {
    $query .= " AND testimonial_id = '" . mysqli_real_escape_string($conn, $testimonial_id) . "'";
}

// Add order by clause
$query .= " ORDER BY position ASC";
// Execute the query
$result = mysqli_query($conn, $query);

// Check if the query was successful
if (!$result) {
    echo json_encode(["status" => "error", "message" => "Failed to fetch testimonials"]);
    exit;
}

// Fetch the results as an associative array
$testimonials = [];
while ($row = mysqli_fetch_assoc($result)) {
    $testimonials[] = [
        "testimonial_id" => $row['testimonial_id'],
        "byname" => $row['byname'],
        "title" => $row['Title'],
        "description" => $row['Description'],
        "image" => $row['Image'],
        "position" => $row['position'],
        "active" => $row['active']
    ];
}

// Return the results as JSON
echo json_encode([
    "status" => "success",
    "testimonials" => $testimonials
]);
?>
